import { defineConfig } from "vite";

export default defineConfig({
    base: "./",
    server: { host: "0.0.0.0", port: 3000 },
    preview: { host: "0.0.0.0", port: 3000 },
    build: {
        assetsDir: "./",
        rollupOptions: {
            output: {
                manualChunks: (id) => {
                    if (id.includes("node_modules/three"))
                        return "three";
                }
            }
        }
    },
});
